﻿uses GraphABC;

procedure DrawBees72Graph();
var
  x0, y0, scale: integer;
  
  // Функция: f(n) = √(n/2) + (8/9)n + 2 - n
  function f(n: real): real;
  begin
    Result := Sqrt(n/2) + (8/9)*n + 2 - n;
  end;
  
  // Упрощенная: f(n) = √(n/2) - n/9 + 2
  function f_simple(n: real): real;
  begin
    Result := Sqrt(n/2) - n/9 + 2;
  end;
  
begin
  // Настройки окна
  Window.Title := 'Индийские пчёлы граф';
  Window.SetSize(800, 500);
  Window.CenterOnScreen;
  
  // Фон
  Brush.Color := Color.White;
  FillRectangle(0, 0, Window.Width, Window.Height);
  
  // Начало координат и масштаб
  x0 := 100;    // Отступ слева
  y0 := 400;    // Нулевая линия по Y
  scale := 5;   // Пикселей на единицу (для больших n)
  
  // Рисуем ось X (количество пчёл)
  Pen.Color := Color.Black;
  Pen.Width := 2;
  Line(50, y0, Window.Width - 50, y0);
  
  // Подписи на оси X
  for var i := 0 to 100 do
    if i mod 4 = 0 then
    begin
      var xpos := x0 + i * scale;
      // Отметки
      Line(xpos, y0 - 5, xpos, y0 + 5);
      // Числа
      if i = 72 then
      begin
        Font.Color := Color.Red;
        Font.Style := fsBold;
      end
      else
      begin
        Font.Color := Color.Black;
        Font.Style := fsNormal;
      end;
      TextOut(xpos - 8, y0 + 10, i.ToString);
    end;
  
  Font.Color := Color.Black;
  TextOut(Window.Width - 40, y0 + 10, 'n');
  TextOut(x0 + 200, y0 + 30, 'Количество пчёл в рое');
  
  // Рисуем ось Y
  Line(x0, 50, x0, Window.Height - 50);
  
  // Подписи на оси Y
  for var i := -30 to 30 do
    if i mod 10 = 0 then
    begin
      var ypos := y0 - i * scale;
      // Отметки
      Line(x0 - 5, ypos, x0 + 5, ypos);
      // Числа
      TextOut(x0 - 25, ypos - 8, (i div 10).ToString);
    end;
  TextOut(x0 - 20, 40, 'f(n)');
  
  // Рисуем график f(n) = √(n/2) - n/9 + 2
  Pen.Color := Color.Blue;
  Pen.Width := 3;
  
  var first := true;
  for var i := 0 to 100 do
  begin
    var n := i;
    var y := f_simple(n);
    var xpos := x0 + n * scale;
    var ypos := y0 - Round(y * scale * 10);
    
    if first then
    begin
      MoveTo(xpos, ypos);
      first := false;
    end
    else
      LineTo(xpos, ypos);
  end;
  
  // Горизонтальная линия y=0
  Pen.Color := Color.Green;
  Pen.Width := 1;
  Pen.Style := psDash;
  Line(x0, y0, x0 + 100 * scale, y0);
  Pen.Style := psSolid;
  
  // Отмечаем решение n=72
  var n72 := 72;
  var y72 := f_simple(n72);
  var xpos72 := x0 + n72 * scale;
  var ypos72 := y0 - Round(y72 * scale);
  
  Pen.Color := Color.Red;
  Pen.Width := 8;
  Circle(xpos72, ypos72, 10);
  
  // Вертикальная линия к оси X
  Pen.Color := Color.Gray;
  Pen.Width := 1;
  Pen.Style := psDash;
  Line(xpos72, ypos72, xpos72, y0);
  Pen.Style := psSolid;
  
  // Подпись решения
  Brush.Color := Color.White;
  Font.Size := 14;
  Font.Style := fsBold;
  Font.Color := Color.Red;
  TextOut(xpos72 - 20, ypos72 - 40, 'n = 72');
end;

begin
  DrawBees72Graph();
end.